// 2003/03/18 AppConfigManager.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.IO;
using System.Xml;
using System.Windows.Forms;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// AvP[V̐ݒ̕ێAǂݏ𓝍AǗB
	/// </summary>
	public class AppConfigManager
	{

		string hxdConfigPath = "./Data/hxd.conf";
		/// <summary>
		/// HXD̐ݒt@C̃pXB
		/// </summary>
		public string HXDConfigPath
		{
			get{return hxdConfigPath;}
		}

		string hxdPath  = "hxd.exe";
		/// <summary>
		/// HXD̃pX
		/// </summary>
		public string HXDPath
		{
			get{return hxdPath;}
		}

		bool emuMacRes = false;
		public bool EmuMacRes
		{
			get{return emuMacRes;}
			set{emuMacRes = value;}
		}

		bool enableTracker = false;
		/// <summary>
		/// gbJ[ɓo^B
		/// </summary>
		public bool EnableTrakcer
		{
			get{return enableTracker;}
			set{enableTracker = value;}
		}

		bool autoStart = false;
		/// <summary>
		/// NɃT[o[NB
		/// </summary>
		public bool AutoStart
		{
			get{return autoStart;}
			set{autoStart = value;}
		}

		bool autoTray = false;
		/// <summary>
		/// NɃT[o[Ɋi[B
		/// </summary>
		public bool AutoTray 
		{
			get{return autoTray;}
			set{autoTray = value;}
		}

		bool enableMultipleBoot = false;
		/// <summary>
		/// dNB
		/// </summary>
		public bool EnableMultipleBoot
		{
			get{return enableMultipleBoot;}
			set{enableMultipleBoot = value;}
		}


		bool autoReload = true;
		/// <summary>
		/// OAj[XIɍXV鎞,true
		/// </summary>
		public bool AutoReload
		{
			get{return autoReload;}
			set{autoReload = value;}
		}

		bool logClear = false;
		/// <summary>
		/// OT[o[~ɃNAB
		/// </summary>
		public bool LogClear
		{
			get{return logClear;}
			set{logClear = value;}
		}

		public AppConfigManager()
		{
		}

		public void Load()
		{
			try 
			{ 

				using( StreamReader streamReader = new StreamReader(Application.StartupPath + "\\Data\\Setting.xml"))
				{

					XmlTextReader reader = new XmlTextReader(streamReader); 

					while ( reader.Read() ) 
					{ 

						if (reader.NodeType != XmlNodeType.Element) 
						{ 
							continue; 
						} 

						switch (reader.Name)	
						{
							case "HXDConfigPath":
								reader.Read();
								this.hxdConfigPath	= reader.Value; 
								reader.Read();
								break;

							case "HXDPath":
								reader.Read();
								this.hxdPath	= reader.Value; 
								reader.Read();
								break;

							case "EnableTrakcer":
								reader.Read();
								this.enableTracker	= bool.Parse(reader.Value); 
								reader.Read();
								break;

							case "AutoStart":
								reader.Read();
								this.autoStart	= bool.Parse(reader.Value); 
								reader.Read();
								break;

							case "AutoTray":
								reader.Read();
								this.autoTray	= bool.Parse(reader.Value); 
								reader.Read();
								break;
				
							case "EnableMultipleBoot":
								reader.Read();
								this.enableMultipleBoot	= bool.Parse(reader.Value); 
								reader.Read();
								break;

							case "AutoReload":
								reader.Read();
								this.autoReload	= bool.Parse(reader.Value); 
								reader.Read();
								break;


							case "LogClear":
								reader.Read();
								this.logClear	= bool.Parse(reader.Value); 
								reader.Read();
								break;
								

						}
					}
				}
			}
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
			}
		}

		public bool Save()
		{
			try
			{
				using(FileStream fileStream	= new FileStream( Application.StartupPath + "\\Data\\Setting.xml", FileMode.Create ,FileAccess.Write ))
				{

					XmlTextWriter writer	= new XmlTextWriter( fileStream , System.Text.Encoding.UTF8 );
					writer.Formatting = Formatting.Indented; 
					writer.Indentation = 2; 

					writer.WriteStartElement("AppConfig");

					writer.WriteElementString( "HXDConfigPath" , this.HXDConfigPath );
					writer.WriteElementString( "HXDPath"	,  this.HXDPath );
					writer.WriteElementString( "EnableTrakcer" , XmlConvert.ToString( this.enableTracker ));
					writer.WriteElementString( "AutoStart" , XmlConvert.ToString( this.autoStart ));
					writer.WriteElementString( "AutoTray" , XmlConvert.ToString( this.autoTray ));
					writer.WriteElementString( "EnableMultipleBoot" , XmlConvert.ToString( this.enableMultipleBoot ));
					writer.WriteElementString( "AutoReload" , XmlConvert.ToString( this.autoReload ));
					writer.WriteElementString( "LogClear" , XmlConvert.ToString( this.logClear ));

					writer.WriteEndElement();
					writer.Close();
				}
			}
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
				return false;
			}
			return true;
		}
	}
}
